﻿//*****************************************************************************
//
// TextGridCtrl143TestDlg.cpp                               (C)1997-2025 kuzu
//
//*****************************************************************************

// これはMicrosoft Visual Studio 2022 Community で作られています。
// このライブラリは、オープンソースです。
// このライブラリは、GNU劣等一般公衆利用許諾契約書(LGPL2.1)に基づき配布されます。
// このライブラリは、Mozilla Public License 2.0 (MPL2.0)に基づき配布されます。

#include <afxwin.h>
#include "..\\..\\TextGridCtrl143\\TextGridCtrl143.h"
#include "resource.h"
#include "TextGridCtrl143TestApp.h"
#include "TextGridCtrl143TestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define IDC_TEXT_GRID_CTRL 5678

/////////////////////////////////////////////////////////////////////////////
// CTextGridCtrl143TestDlg ダイアログ

CTextGridCtrl143TestDlg::CTextGridCtrl143TestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTextGridCtrl143TestDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	// テキストグリッドコントロールの体裁を初期化
	m_theTextGridCtrl.SetTitleHeight (18);
	m_theTextGridCtrl.SetTitleWidth (64);
	m_theTextGridCtrl.SetNumRows (128);
	m_theTextGridCtrl.SetNumCols (3);
	
	// テキストグリッドコントロールのタイトル部分のサイズと文字列を設定
	int i, j;
	for (i = 0; i < m_theTextGridCtrl.GetNumRows (); i++) {
		m_theTextGridCtrl.SetRowHeight (i, 18);
		CString strTemp;
		strTemp.Format (_T("%d"), i);
		m_theTextGridCtrl.SetRowTitle (i, strTemp);
	}
	for (j = 0; j < m_theTextGridCtrl.GetNumCols (); j++) {
		m_theTextGridCtrl.SetColWidth (j, 64);
	}
	m_theTextGridCtrl.SetColTitle (0, _T("x座標[mm]"));
	m_theTextGridCtrl.SetColTitle (1, _T("y座標[mm]"));
	m_theTextGridCtrl.SetColTitle (2, _T("z座標[mm]"));
	m_theTextGridCtrl.SetCellReadOnly (0, 2);
	m_theTextGridCtrl.SetCellReadOnly (1, 1);
	m_theTextGridCtrl.SetCellReadOnly (2, 0);
	m_theTextGridCtrl.SetCellTextColor (0, 0, RGB (0, 255, 255));
	m_theTextGridCtrl.SetCellTextColor (1, 1, RGB (255, 0, 255));
	m_theTextGridCtrl.SetCellTextColor (2, 1, RGB (255, 255, 0));


}

void CTextGridCtrl143TestDlg::DoDataExchange (CDataExchange* pDX) {
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP (CTextGridCtrl143TestDlg, CDialog)
	ON_WM_PAINT ()
	ON_WM_QUERYDRAGICON ()
	ON_WM_CREATE ()
END_MESSAGE_MAP ()

BOOL CTextGridCtrl143TestDlg::OnInitDialog() {
	CDialog::OnInitDialog();
	
	SetIcon(m_hIcon, TRUE); // 大きいアイコンを設定
	SetIcon(m_hIcon, FALSE); // 小さいアイコンを設定
	
	// テキストグリッドコントロールの位置とサイズ調整
	CRect rcStaticDummy;
	CWnd* pStaticDummy = GetDlgItem (IDC_STATIC_DUMMY);
	pStaticDummy->GetWindowRect (&rcStaticDummy);
	this->ScreenToClient (&rcStaticDummy);
	m_theTextGridCtrl.MoveWindow (&rcStaticDummy);
	pStaticDummy->DestroyWindow ();
	return TRUE;
}

void CTextGridCtrl143TestDlg::OnPaint() {
	if (IsIconic()) {
		CPaintDC dc(this); // 描画用のデバイス コンテキスト
		SendMessage (WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		dc.DrawIcon(x, y, m_hIcon);
	}
	else {
		CDialog::OnPaint();
	}
}

HCURSOR CTextGridCtrl143TestDlg::OnQueryDragIcon () {
	return (HCURSOR) m_hIcon;
}

int CTextGridCtrl143TestDlg::OnCreate (LPCREATESTRUCT lpCreateStruct) {
	if (CDialog::OnCreate (lpCreateStruct) == -1) {
		return -1;
	}
	// テキストグリッドコントロールの作成
	m_theTextGridCtrl.CreateEx (WS_EX_CLIENTEDGE, NULL, _T("TEXTGRIDCTRL"), 
		WS_BORDER | WS_VISIBLE | WS_CHILD | WS_TABSTOP | WS_VSCROLL | WS_HSCROLL,
		10, 10, 300, 300, this->m_hWnd, (HMENU)IDC_TEXT_GRID_CTRL, NULL);
	return 0;
}

