﻿//*****************************************************************************
//
//  TextGridCtrl143.h                                       (C)1997-2025 kuzu
//
//*****************************************************************************

// これはMFCのCWndクラスから派生したCTextGridCtrlクラスを定義します。
// ■CWnd
// └■CTextGridCtrl
// これはMicrosoft Visual Studio 2015 Community で作られています。
// このライブラリは、オープンソースです。
// このライブラリは、GNU劣等一般公衆利用許諾契約書(LGPL2.1)に基づき配布されます。
// このライブラリは、Mozilla Public License 2.0 (MPL2.0)に基づき配布されます。

#ifndef _TEXTGRIDCTRL_H_
#define _TEXTGRIDCTRL_H_

// ウィンドウスタイル
#define TGS_ALIGNLEFT        0x0000L
#define TGS_ALIGNCENTER      0x0001L
#define TGS_ALIGNRIGHT       0x0002L
#define TGS_UPPERCASE        0x0008L
#define TGS_LOWERCASE        0x0010L
#define TGS_AUTOVSCROLL      0x0040L
#define TGS_AUTOHSCROLL      0x0080L
#define TGS_READONLY         0x0800L
#if(WINVER >= 0x0400)
#define TGS_NUMBER           0x2000L
#endif
#define TGS_ROWHEIGHTFIXED   0x4000L
#define TGS_COLWIDTHFIXED    0x8000L

// 親ウィンドウ通知メッセージ
// 0x8000～0x7FFFはWindowsで未使用、
// 他社製ライブラリと重複する場合はメッセージリフレクションで
// どのコントロールIDから通知が来たか分岐させる処理を要する。
#define TGN_SETFOCUS 0x9E01
#define TGN_KILLFOCUS 0x9E02
#define TGN_ROWTITLECHANGE 0x9E03
#define TGN_COLTITLECHANGE 0x9E04
#define TGN_CELLSTRINGCHANGE 0x9E05
#define TGN_CURCELLCHANGE 0x9E06
#define TGN_SELECTCHANGE 0x9E07
#define TGN_ROWHEIGHTCHANGE 0x9E08
#define TGN_COLWIDTHCHANGE 0x9E09
#define TGN_UNDO 0x9E0A
#define TGN_CUT 0x9E0B
#define TGN_COPY 0x9E0C
#define TGN_PASTE 0x9E0D
#define TGN_DELETE 0x9E0E
#define TGN_HSCROLL 0x9E0F
#define TGN_VSCROLL 0x9E10
#define TGN_REDO 0x9E11

// TextGridCtrl Notification Codes
#define ON_TGN_SETFOCUS(id, memberFxn) \
	ON_NOTIFY(TGN_SETFOCUS, id, memberFxn)
#define ON_TGN_KILLFOCUS(id, memberFxn) \
	ON_NOTIFY(TGN_KILLFOCUS, id, memberFxn)
#define ON_TGN_ROWTITLECHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_ROWTITLECHANGE, id, memberFxn)
#define ON_TGN_COLTITLECHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_COLTITLECHANGE, id, memberFxn)
#define ON_TGN_CELLSTRINGCHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_CELLSTRINGCHANGE, id, memberFxn)
#define ON_TGN_CURCELLCHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_CURCELLCHANGE, id, memberFxn)
#define ON_TGN_SELECTCHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_SELECTCHANGE, id, memberFxn)
#define ON_TGN_ROWHEIGHTCHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_ROWHEIGHTCHANGE, id, memberFxn)
#define ON_TGN_COLWIDTHCHANGE(id, memberFxn) \
	ON_NOTIFY(TGN_COLWIDTHCHANGE, id, memberFxn)
#define ON_TGN_UNDO(id, memberFxn) \
	ON_NOTIFY(TGN_UNDO, id, memberFxn)
#define ON_TGN_REDO(id, memberFxn) \
	ON_NOTIFY(TGN_REDO, id, memberFxn)
#define ON_TGN_CUT(id, memberFxn) \
	ON_NOTIFY(TGN_CUT, id, memberFxn)
#define ON_TGN_COPY(id, memberFxn) \
	ON_NOTIFY(TGN_COPY, id, memberFxn)
#define ON_TGN_PASTE(id, memberFxn) \
	ON_NOTIFY(TGN_PASTE, id, memberFxn)
#define ON_TGN_DELETE(id, memberFxn) \
	ON_NOTIFY(TGN_DELETE, id, memberFxn)
#define ON_TGN_HSCROLL(id, memberFxn) \
	ON_NOTIFY(TGN_HSCROLL, id, memberFxn)
#define ON_TGN_VSCROLL(id, memberFxn) \
	ON_NOTIFY(TGN_VSCROLL, id, memberFxn)

// コンテキストメニュー部リソースID定義(番号は適当)
#define IDR_CONTEXTMENU     1001
#define IDM_CONTEXT_UNDO    1002
#define IDM_CONTEXT_REDO    1003
#define IDM_CONTEXT_CUT     1004
#define IDM_CONTEXT_COPY    1005
#define IDM_CONTEXT_PASTE   1006
#define IDM_CONTEXT_DELETE  1007

//#undef  AFX_DATA
//#define AFX_DATA AFX_EXT_CLASS

#define TEXTGRIDCTRL_MODIFYCURCELL       0x0010
#define TEXTGRIDCTRL_MODIFYSELECT        0x0020
#define TEXTGRIDCTRL_MODIFYCELLSTRING    0x0100
#define TEXTGRIDCTRL_MODIFYREADONLY      0x0200
#define TEXTGRIDCTRL_MODIFYTEXTCOLOR     0x0400

//*****************************************************************************
//
// TextGridNotify構造体
//
//*****************************************************************************

typedef struct tagTextGridNotify {
	NMHDR hdr;
	int m_nRow;
	int m_nCol;
	int m_nTopRow;
	int m_nBottomRow;
	int m_nLeftCol;
	int m_nRightCol;
} TextGridNotify;

//*****************************************************************************
//
// CTextGridHistoryEventクラス
//
//*****************************************************************************

class AFX_EXT_CLASS CTextGridHistoryEvent {
public:
	CTextGridHistoryEvent ();
	virtual ~CTextGridHistoryEvent ();
public:
	int m_nEventType;
	int m_nModifiedTopRow;
	int m_nModifiedBottomRow;
	int m_nModifiedLeftCol;
	int m_nModifiedRightCol;
	int m_nOldCurRow;
	int m_nOldCurCol;
	int m_nOldSelectedTopRow;
	int m_nOldSelectedBottomRow;
	int m_nOldSelectedLeftCol;
	int m_nOldSelectedRightCol;
	CStringArray m_theOldCellStringArray;
	CUIntArray m_theOldReadOnlyArray;
	CUIntArray m_theOldTextColorArray;
	int m_nNewCurRow;
	int m_nNewCurCol;
	int m_nNewSelectedTopRow; // 選択されている最も上の行
	int m_nNewSelectedBottomRow; // 選択されている最も下の行
	int m_nNewSelectedLeftCol; // 選択されている最も左の行
	int m_nNewSelectedRightCol; // 選択されている最も右の行
	CStringArray m_theNewCellStringArray;
	CUIntArray m_theNewReadOnlyArray;
	CUIntArray m_theNewTextColorArray;
};

//*****************************************************************************
//
// CTextGridHistoryBlockクラス
//
//*****************************************************************************

class AFX_EXT_CLASS CTextGridHistoryBlock {
public:
	CTextGridHistoryBlock ();
	virtual ~CTextGridHistoryBlock ();
public:
	CString m_strName;
	CTime m_theTime;
	CPtrArray m_theHistoryEventArray;
};

//*****************************************************************************
//
// CTextGridEditクラス
//
//*****************************************************************************

class AFX_EXT_CLASS CTextGridEdit : public CEdit {

	DECLARE_DYNCREATE (CTextGridEdit);

	// コンストラクタとデストラクタ
public:
	CTextGridEdit ();
	virtual ~CTextGridEdit ();

	// メッセージマップ
protected:
	afx_msg void OnKillFocus (CWnd* pNewWnd);
	afx_msg void OnKeyDown (UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar (UINT nChar, UINT nRepCnt, UINT nFlags);
	DECLARE_MESSAGE_MAP ()
};

//*****************************************************************************
//
// CTextGridCtrlクラス
//
//*****************************************************************************

class AFX_EXT_CLASS CTextGridCtrl : public CWnd {

	DECLARE_DYNCREATE (CTextGridCtrl)

	// コンストラクタとデストラクタ
public:
	CTextGridCtrl ();
	CTextGridCtrl (int nNumRows, int nNumCols);
	virtual ~CTextGridCtrl ();

	// アトリビュート1(ドキュメントデータ)
protected:
	int m_nNumRows; // 行数(グレータイトル行を含まない)
	int m_nNumCols; // 列数(グレータイトル行を含まない)
	int m_nTitleWidth; // タイトル部の高さ[ドット]
	int m_nTitleHeight; // タイトル部の幅[ドット]
	CUIntArray m_theColWidthArray;  // 列高さ配列[ドット]
	CUIntArray m_theRowHeightArray; // 行高さ配列[ドット]
	CStringArray m_theColTitleArray; // 行タイトルの文字列
	CStringArray m_theRowTitleArray; // 列タイトルの文字列
	CStringArray m_theCellStringArray; // 各セルの文字列
	CUIntArray m_theReadOnlyArray; // 各セルがリードオンリーか。
	CUIntArray m_theTextColorArray; // 各セルの文字色

	// アトリビュート2(非ドキュメントデータ)
protected:
	int m_nCurRow; // 現在の行
	int m_nCurCol; // 現在の列
	int m_nVisibleTopRow; // 画面に表示されている最も上の行
	int m_nVisibleLeftCol; // 画面に表示されている最も左の列
	int m_nSelectedTopRow; // 選択されている最も上の行
	int m_nSelectedBottomRow; // 選択されている最も下の行
	int m_nSelectedLeftCol; // 選択されている最も左の行
	int m_nSelectedRightCol; // 選択されている最も右の行
	BOOL m_bReadOnly;

	// アトリビュート3(一時的な状況保存用データ)
protected:
	CPoint m_ptMouseDown; // マウスが押された座標
	CPoint m_ptMouseMove; // 最後にマウスが動かされた座標
	int m_nMouseMode;
	int m_nMouseDownRow;
	int m_nMouseDownCol;
	int m_nMouseDownRowBorder;
	int m_nMouseDownColBorder;
	int m_nKeyMoveRow;
	int m_nKeyMoveCol;
	int m_bCut;
	int m_nMouseDownRowHeight;
	int m_nMouseDownColWidth;
	int m_bNotify;

	// アトリビュート4(描画オブジェクトなど)
protected:
	CPen m_theGridPen; // グリッド描画用ペン
	CPen m_theCurCellPen; // カレントセル描画用ペン
	CBrush m_theNullBrush; // カレントセル背景用透明ブラシ
	CBrush m_theWindowBackBrush; // ウィンドウ背景描画用ブラシ
	CFont m_theTextFont; // 文字描画用フォント
	CTextGridEdit m_theTextBox; // テキスト入力時だけVisibleになるテキストボックス
	CMenu m_theContextMenu; // 右クリック用のコンテキストメニュー

	// アトリビュート5(履歴)
protected:
	int m_nCurHistoryIndex;
	CPtrArray m_theHistoryBlockArray;

	// オペレーション
public:
	// 行数と列数の取得と設定
	int GetNumRows () const
	{
		return m_nNumRows;
	}
	int GetNumCols () const
	{
		return m_nNumCols;
	}
	BOOL SetNumRows (int nNumRows);
	BOOL SetNumCols (int nNumCols);
	// タイトル幅とタイトル高さの取得と設定
	int GetTitleHeight () const
	{
		return m_nTitleHeight;
	}
	int GetTitleWidth () const
	{
		return m_nTitleWidth;
	}
	BOOL SetTitleHeight (int nHeight);
	BOOL SetTitleWidth (int nWidth);

	// 行幅と列幅の取得と設定
	int GetRowHeight (int nRow) const;
	int GetColWidth (int nCol) const;
	BOOL SetRowHeight (int nRow, int nHeight);
	BOOL SetColWidth (int nCol, int nWidth);
	int GetCellSumHeight () const;
	int GetCellSumWidth () const;

	// 各文字列の取得と設定
	CString GetRowTitle (int nRow) const;
	CString GetColTitle (int nCol) const;
	CString GetCellString (int nRow, int nCol) const;
	double GetCellDouble (int nRow, int nCol) const;
	BOOL SetRowTitle (int nRow, CString strRowTitle);
	BOOL SetColTitle (int nCol, CString strColTitle);
	BOOL SetCellString (int nRow, int nCol, CString strGridString);
	BOOL SetCellStringWithNotify (int nRow, int nCol, CString strGridString);
	//BOOL GetLastNotifyInfo (int* pRow, int* pCol, int* pLeft, int* pTop, int* pRight, int* pBottom) const;
	BOOL SetCellDouble (int nRow, int nCol, double dValue, LPCTSTR lpszFormat = NULL);
	void DeleteAllRowTitle ();
	void DeleteAllColTitle ();
	void DeleteAllCellString ();

	// 行列の挿入と削除
	BOOL InsertRow (int nRow);
	BOOL InsertCol (int nCol);
	BOOL RemoveRow (int nRow);
	BOOL RemoveCol (int nCol);

	// 画面に表示されている行列範囲の取得と設定
	int GetVisibleTopRow () const
		{return m_nVisibleTopRow;}
	int GetVisibleLeftCol () const
		{return m_nVisibleLeftCol;}
	int GetVisibleBottomRow (long lLogPixelsX, long lLogPixelsY) const;
	int GetVisibleRightCol (long lLogPixelsX, long lLogPixelsY) const;
	BOOL SetVisibleTopRow (int nVisibleTopRow, long lLogPixelsX, long lLogPixelsY);
	BOOL SetVisibleLeftCol (int nVisibleLeftCol, long lLogPixelsX, long lLogPixelsY);
	BOOL SetVisibleBottomRow (int nVisibleBottomRow, long lLogPixelsX, long lLogPixelsY);
	BOOL SetVisibleRightCol (int nVisibleRightCol, long lLogPixelsX, long lLogPixelsY);

	// 選択範囲関係
	BOOL GetSelectedArea (int* pRow1, int* pRow2, int* pCol1, int* pCol2) const;
	BOOL SelectCell (int nRow, int nCol);
	BOOL SelectCellWithNotify (int nRow, int nCol);
	BOOL SelectArea (int nRow1, int nRow2, int nCol1, int nCol2);
	BOOL SelectAreaWithNotify (int nRow1, int nRow2, int nCol1, int nCol2);
	BOOL SelectRow (int nRow1, int nRow2);
	BOOL SelectRowWithNotify (int nRow1, int nRow2);
	BOOL SelectCol (int nCol1, int nCol2);
	BOOL SelectColWithNotify (int nCol1, int nCol2);
	BOOL SelectAll ();
	BOOL SelectAllWithNotify ();
	BOOL IsSelectedCell (int nRow, int nCol) const;
	BOOL IsSelectedRow (int nRow) const;
	BOOL IsSelectedCol (int nCol) const;
	BOOL IsSelectedAll () const;

	// カレント行列の取得と設定
	int GetCurRow () const
		{return m_nCurRow;}
	int GetCurCol () const
		{return m_nCurCol;}
	BOOL SetCurCell (int nRow, int nCol);
	BOOL SetCurCellWithNotify (int nRow, int nCol);
	BOOL SetCurCell (int nRow, int nCol, long lLogPixelsX, long lLogPixelsY);
	BOOL SetCurCellWithNotify (int nRow, int nCol, long lLogPixelsX, long lLogPixelsY);

	// オートスクロール処理
	BOOL AutoScrolltoShowCell (int nRow, int nCol, long lLogPixelsX, long lLogPixelsY);
	BOOL AutoScrolltoShowRow (int nRow, long lLogPixelsX, long lLogPixelsY);
	BOOL AutoScrolltoShowCol (int nCol, long lLogPixelsX, long lLogPixelsY);

	// ウィンドウスタイルの取得と設定
	BOOL IsReadOnly () const;
	BOOL IsCellReadOnly (int nRow, int nCol) const;
	BOOL SetReadOnly (BOOL bReadOnly = TRUE);
	BOOL SetCellReadOnly (int nRow, int nCol, BOOL bReadOnly = TRUE);
	COLORREF GetCellTextColor (int nRow, int nCol) const;
	BOOL SetCellTextColor (int nRow, int nCol, COLORREF nColor);
	BOOL IsRowHeightFixed () const;
	BOOL SetRowHeightFixed (BOOL bRowHeightFixed = TRUE);
	BOOL IsColWidthFixed () const;
	BOOL SetColWidthFixed (BOOL bRowHeightFixed = TRUE);

protected:
	// スクロールバー関係
	BOOL AdjustVScrollBar ();
	BOOL AdjustHScrollBar ();

	// 座標変換関係
	BOOL PointToCell (CPoint point, int* pRow, int* pCol, long lLogPixelsX, long lLogPixelsY) const;
	BOOL PointToBorder (CPoint point, int* pRowBorder, int* pColBorder, long lLogPixelsX, long lLogPixelsY) const;
	BOOL CellToRect (int nRow, int nCol, CRect* pRect, long lLogPixelsX, long lLogPixelsY) const;


	// テキストボックス処理
	BOOL IsTextEditing () const;
	BOOL BeginTextEditing ();
	BOOL BeginTextEditingContinue ();
	BOOL EndTextEditingOK ();
	BOOL EndTextEditingCancel ();
	BOOL MoveTextBox (long lLogPixelsX, long lLogPixelsY);
public:
	// 編集処理
	BOOL CutWithNotify ();
	BOOL Cut ();
	BOOL CopyWithNotify ();
	BOOL Copy ();
	BOOL PasteWithNotify ();
	BOOL Paste ();
	BOOL DeleteWithNotify ();
	BOOL Delete ();
	BOOL UndoWithNotify ();
	BOOL Undo ();
	BOOL RedoWithNotify ();
	BOOL Redo ();

	// ヒストリ関係
protected:
	BOOL AddHistoryBlock (CTextGridHistoryBlock* pHistoryBlock);
	BOOL AddHistoryEvent (CTextGridHistoryEvent* pHistoryEvent);
	BOOL DeleteHistoryBlockAfter (int nHistoryIndex);
public:
	BOOL ClearHistory ();
protected:
	BOOL UpdateContextMenuState ();

	// オーバーライド
protected:
	virtual BOOL PreTranslateMessage (MSG* pMsg);

	// メッセージマップ
protected:
	afx_msg int OnCreate (LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy ();
	afx_msg void OnSize (UINT nType, int cx, int cy);
	afx_msg void OnEnable (BOOL bEnable);
	afx_msg void OnSetFocus (CWnd* pOldWnd);
	afx_msg void OnKillFocus (CWnd* pNewWnd);
	afx_msg void OnVScroll (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll (UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
 	afx_msg BOOL OnEraseBkgnd (CDC* pDC);
	afx_msg void OnPaint ();
	afx_msg void OnLButtonDown (UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown (UINT nFlags, CPoint point);
	afx_msg void OnMouseMove (UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp (UINT nFlags, CPoint point);
	afx_msg void OnLButtonDblClk (UINT nFlags, CPoint point);
	afx_msg BOOL OnMouseWheel (UINT nFlags, short zDelta, CPoint point);
	afx_msg void OnKeyDown (UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnChar (UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg LRESULT OnImeStartComposition (WPARAM wParam, LPARAM lParam);
	afx_msg void OnContextUndo ();
	afx_msg void OnUpdateContextUndo (CCmdUI* pCmdUI);
	afx_msg void OnContextRedo ();
	afx_msg void OnUpdateContextRedo (CCmdUI* pCmdUI);
	afx_msg void OnContextCut ();
	afx_msg void OnUpdateContextCut (CCmdUI* pCmdUI);
	afx_msg void OnContextCopy ();
	afx_msg void OnUpdateContextCopy (CCmdUI* pCmdUI);
	afx_msg void OnContextPaste ();
	afx_msg void OnUpdateContextPaste (CCmdUI* pCmdUI);
	afx_msg void OnContextDelete ();
	afx_msg void OnUpdateContextDelete (CCmdUI* pCmdUI);
	DECLARE_MESSAGE_MAP ()
};

//#undef  AFX_DATA
//#define AFX_DATA


#endif
